-- Macro Scripts File
--
-- Macro Scripts for Trajectories maxscript commands
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK

MacroScript TrajTickFramesUnselected
	ButtonText:~TRAJ_TICKFRAMESUNSEL_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_TICKFRAMESUNSEL_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	on isChecked do
	(
		maxOps.unselTrajectoryDrawFrameTicks
	)
	 
	on isEnabled do
	(
		maxOps.trajectoryMode
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode
	)
	 
	on execute do 
	(
		maxOps.unselTrajectoryDrawFrameTicks = NOT maxOps.unselTrajectoryDrawFrameTicks
	)
)

MacroScript TrajDrawKeysUnselected
	ButtonText:~TRAJ_DRAWKEYSUNSEL_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_DRAWKEYSUNSEL_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	on isChecked do
	(
		maxOps.unselTrajectoryDrawKeys
	)
	 
	on isEnabled do
	(
		maxOps.trajectoryMode
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode
	)
	 
	on execute do 
	(
		maxOps.unselTrajectoryDrawKeys = NOT maxOps.unselTrajectoryDrawKeys
	)
)

MacroScript TrajDrawKeysSelected
	ButtonText:~TRAJ_DRAWKEYSSEL_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_DRAWKEYSSEL_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	on isChecked do
	(
		maxOps.selTrajectoryDrawKeys
	)
	 
	on isEnabled do
	(
		maxOps.trajectoryMode
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode
	)
	 
	on execute do 
	(
		maxOps.selTrajectoryDrawKeys = NOT maxOps.selTrajectoryDrawKeys
	)
)

MacroScript TrajGradientPathSpeedColor
	ButtonText:~TRAJ_GRADIENTPATH_SPEED_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_GRADIENTPATH_SPEED_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	on isChecked do
	(
		maxOps.trajectoryPathGradation == #speed
	)
	 
	on isEnabled do
	(
		maxOps.trajectoryPathGradation != #speed
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode
	)
	 
	on execute do 
	(
		maxOps.trajectoryPathGradation = #speed
	)
)

MacroScript TrajGradientPathWireColor
	ButtonText:~TRAJ_GRADIENTPATH_WIRECOLOR_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_GRADIENTPATH_WIRECOLOR_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	on isChecked do
	(
		maxOps.trajectoryPathGradation == #wireColor
	)
	 
	on isEnabled do
	(
		maxOps.trajectoryPathGradation != #wireColor
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode
	)
	 
	on execute do 
	(
		maxOps.trajectoryPathGradation = #wireColor
	)
)

MacroScript TrajGradientPathUIColor
	ButtonText:~TRAJ_GRADIENTPATH_UICOLOR_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_GRADIENTPATH_UICOLOR_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	on isChecked do
	(
		maxOps.trajectoryPathGradation == #UIcolor
	)
	 
	on isEnabled do
	(
		maxOps.trajectoryPathGradation != #UIcolor
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode
	)
	 
	on execute do 
	(
		maxOps.trajectoryPathGradation = #UIcolor
	)
)

MacroScript TrajGradientPathNone
	ButtonText:~TRAJ_GRADIENTPATH_NONE_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_GRADIENTPATH_NONE_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	on isChecked do
	(
		maxOps.trajectoryPathGradation == #none
	)
	 
	on isEnabled do
	(
		maxOps.trajectoryPathGradation != #none
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode
	)
	 
	on execute do 
	(
		maxOps.trajectoryPathGradation = #none
	)
)

MacroScript TrajBreakSelectedTangent
	ButtonText:~TRAJ_BREAKTANGENT_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_BREAKTANGENT_TOOLTIP~
	SilentErrors:(Debug != True) 
(
 
	on isEnabled do
	(
		selection.count > 0
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode
	)
	 
	on execute do 
	(
		maxOps.breakSelectedKeyTangent()
	)
)

MacroScript TrajUnifySelectedTangent
	ButtonText:~TRAJ_UNIFYTANGENT_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_UNIFYTANGENT_TOOLTIP~
	SilentErrors:(Debug != True) 
(
 
	on isEnabled do
	(
		selection.count > 0
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode
	)
	 
	on execute do 
	(
		maxOps.UnifySelectedKeyTangent()
	)
)

MacroScript TrajSetToAutoSelectedTangent
	ButtonText:~TRAJ_SETTOAUTO_TANGENT_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_SETTOAUTO_TANGENT_TOOLTIP~
	SilentErrors:(Debug != True) 
(
 
	on isEnabled do
	(
		selection.count > 0
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode
	)
	 
	on execute do 
	(
		maxOps.setSelectedKeyTangentToAuto()
	)
)

MacroScript ShowFullTrajectories
	ButtonText:~TRAJ_SHOWFULLTRAJECTORY_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_SHOWFULLTRAJECTORY_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	on isEnabled do
	(
		maxOps.trajectoryMode AND maxOps.TrimTrajectories
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode
	)
	 
	on execute do 
	(
		maxOps.TrimTrajectories = false
	)
)

MacroScript TrimTrajectoriesWithFixedFrames
	ButtonText:~TRAJ_TRIMTRAJECTORY_FIXEDFRAMES_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_TRIMTRAJECTORY_FIXEDFRAMES_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	on isEnabled do
	(
		maxOps.trajectoryMode AND (NOT maxOps.TrimTrajectories OR NOT maxOps.FixedTrimRange)
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode 
	)
	 
	on execute do 
	(
		maxOps.TrimTrajectories = true
		maxOps.FixedTrimRange = true
	)
)

MacroScript TrimTrajectoriesWithMovingFrames
	ButtonText:~TRAJ_TRIMTRAJECTORY_MOVINGFRAMES_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_TRIMTRAJECTORY_MOVINGFRAMES_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	on isEnabled do
	(
		maxOps.trajectoryMode AND (NOT maxOps.TrimTrajectories OR maxOps.FixedTrimRange)
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode 
	)
	 
	on execute do 
	(
		maxOps.TrimTrajectories = true
		maxOps.FixedTrimRange = false
	)
)

MacroScript TrajDrawAllHandles
	ButtonText:~TRAJ_DRAWALLHANDLES_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_DRAWALLHANDLES_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	on isChecked do
	(
		maxOps.DrawAllHandles
	)
	 
	on isEnabled do
	(
		maxOps.trajectoryMode
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode
	)
	 
	on execute do 
	(
		maxOps.DrawAllHandles = NOT maxOps.DrawAllHandles
	)
)

MacroScript TrajTickFramesSelected
	ButtonText:~TRAJ_TICKFRAMESSEL_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_TICKFRAMESSEL_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	on isChecked do
	(
		maxOps.SelTrajectoryDrawFrameTicks
	)
	 
	on isEnabled do
	(
		maxOps.trajectoryMode
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode
	)
	 
	on execute do 
	(
		maxOps.SelTrajectoryDrawFrameTicks = NOT maxOps.SelTrajectoryDrawFrameTicks
	)
)

MacroScript TrajDrawGradientTicks
	ButtonText:~TRAJ_DRAWGRADIENTTICKS_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_DRAWGRADIENTTICKS_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	on isChecked do
	(
		maxOps.DrawGradientTicks
	)
	 
	on isEnabled do
	(
		maxOps.trajectoryMode AND maxOps.SelTrajectoryDrawFrameTicks
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode
	)
	 
	on execute do 
	(
		maxOps.DrawGradientTicks = NOT maxOps.DrawGradientTicks
	)
)
-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCM0OGx1sm2rZn1fJQQjXLeQS8v4LdOft4Q
-- mkExwMcgLWZV/KDZ/afy80Zs21JLwQCeojIU+ES8QdXF22oRl1PViQNc3ZN5ABno
-- 8J3fm0g+Ch7uodlGxZGSEUBcFnx1wV2cobetGbjE2l7l8mTEjoxusDQFQVDq7n8H
-- cWrexXuf8mK5zsT7z6Z3bdMQ7dx726DwpKd5OQOeNvznPgrTZ8oF5jgMwrNjdoNH
-- d/XwpdpHHsgemrIWOzghh+pHRkvVqEIHb21JMwxaZTU3bK1bhaka3QA3yyLlp+wU
-- 8D1IC6HHGk1dXKMisyXctjrjvbGeIdu53HG+CfjplR+Yen2LYdPl
-- -----END-SIGNATURE-----